<?php namespace App\Http\Controllers;
use Illuminate\Support\Faccontactes\Validator;
use Illuminate\Http\Request;
use Session;
use Redirect;
use Auth;
use DB;
class CompaniesController extends Controller {

    /* Admin to add companies
    *  23-01-2021
    */
    public function addCompanies(Request $req){
      
        return view('admin.companies.add');
    }
     
    /* Admin to add companies
    *  23-01-2021
    */
    public function addPostCompanies(Request $req){
        
        $company                = new \App\Company;
        $company->name          = $req->input('name');
        $company->location      = $req->input('location');
        $company->address       = $req->input('address');
        $company->status        = $req->input('status');
        $company->save();
        return Redirect::to('admin/companies')->with('success', 'Company added successfully!');
      

        
    }

    /* Admin to edit companies
    *  23-01-2021
    */
    public function editCompanies(Request $req,$id){


        $company  = \App\Company::where('id',$id)
                ->first();

      
        return view('admin.companies.edit',['company' => $company]);
    }
     
    /* Admin to add companies
    *  23-01-2021
    */
    public function editPostCompanies(Request $req){

        $id = $req->input('id');
    
        $company                = \App\Company::findOrFail($id);
        $company->name          = $req->input('name');
        $company->location      = $req->input('location');
        $company->address       = $req->input('address');
        $company->status        = $req->input('status');
        $company->save();
        return Redirect::to('admin/companies')->with('success', 'Company updated successfully!');
   

        
    }

    /* Admin list contacts page
    *  17-03-2020
    */
    public function getCompanies(){

        $companies = \App\Company::paginate(15);
        return view('admin.companies.index',['companies'=>$companies]);

    }

    /* Admin view contact details
    *  13-03-2019
    */
    public function companyView(Request $req,$id){
    
        $company  = \App\Company::where('id',$id)
             ->first();
        return view('admin.companies.view',['company'=>$company]);
    
    }

    /* To delete contact
    *  13-03-2020
    */
    public function CompaniesDelete($id){
        if(!empty($id)){
            $company = \App\Company::findOrFail($id);
            if($company){
                \App\Company::destroy($id);
                return Redirect::to('admin/companies')->with('success', 'Company deleted successfully!');
            }
        }else{
            return Redirect::to('admin/companies')->with('error', 'You cannot delete!');
        }
    }

    /*Admin change status of companies
    * 23-01-2021
    */
    public function changeStatus(Request $req){

        $id             = $req->input('id');
        $status         = $req->input('status');
       
        $data           = $req->input('data');
        $company  = \App\Company::findOrFail($id);
        if($company){

            if($data == 1){
                
                $company->status = $status;

            }else{
                
                if($status == 1){
                
                    $company->status = 0;
                
                }else{
                
                    $company->status = 1;
                
                }   
            
            }
            
            $company->save();
            return Redirect::back()->with('success', 'Status changed successfully.');

        }
    }
   


}
