<?php namespace App\Http\Controllers;
use Illuminate\Support\Faccontactes\Validator;
use Illuminate\Http\Request;
use Session;
use Redirect;
use Auth;
use DB;

class TaskStatusesController extends Controller {

    /* Admin to add task_statuses
    *  23-01-2021
    */
    public function addTaskStatuses(Request $req){
      
        return view('admin.task_statuses.add');
    }
     
    /* Admin to add task_statuses
    *  23-01-2021
    */
    public function addPostTaskStatuses(Request $req){
        
        $task_status                = new \App\TaskStatus;
        $task_status->name          = $req->input('name');
        $task_status->color          = $req->input('color');
        $task_status->status        = $req->input('status');
        $task_status->save();
        return Redirect::to('admin/task_statuses')->with('success', 'TaskStatus added successfully!');
      

        
    }

    /* Admin to edit task_statuses
    *  23-01-2021
    */
    public function editTaskStatuses(Request $req,$id){


        $task_status  = \App\TaskStatus::where('id',$id)
                ->first();

      
        return view('admin.task_statuses.edit',['task_status' => $task_status]);
    }
     
    /* Admin to add task_statuses
    *  23-01-2021
    */
    public function editPostTaskStatuses(Request $req){

        $id = $req->input('id');
    
        $task_status                = \App\TaskStatus::findOrFail($id);
        $task_status->name          = $req->input('name');
        $task_status->color         = $req->input('color');
        $task_status->status        = $req->input('status');
        $task_status->save();
        return Redirect::to('admin/task_statuses')->with('success', 'TaskStatus updated successfully!');
   

        
    }

    /* Admin list contacts page
    *  17-03-2020
    */
    public function getTaskStatuses(){

        $task_statuses = \App\TaskStatus::paginate(15);
        return view('admin.task_statuses.index',['task_statuses'=>$task_statuses]);

    }

    /* Admin view contact details
    *  13-03-2019
    */
    public function task_statusView(Request $req,$id){
    
        $task_status  = \App\TaskStatus::where('id',$id)
             ->first();
        return view('admin.task_statuses.view',['task_status'=>$task_status]);
    
    }

    /* To delete contact
    *  13-03-2020
    */
    public function TaskStatusesDelete($id){
        if(!empty($id)){
            $task_status = \App\TaskStatus::findOrFail($id);
            if($task_status){
                \App\TaskStatus::destroy($id);
                return Redirect::to('admin/task_statuses')->with('success', 'TaskStatus deleted successfully!');
            }
        }else{
            return Redirect::to('admin/task_statuses')->with('error', 'You cannot delete!');
        }
    }

    /*Admin change status of task_statuses
    * 23-01-2021
    */
    public function changeStatus(Request $req){

        $id             = $req->input('id');
        $status         = $req->input('status');
       
        $data           = $req->input('data');
        $task_status  = \App\TaskStatus::findOrFail($id);
        if($task_status){

            if($data == 1){
                
                $task_status->status = $status;

            }else{
                
                if($status == 1){
                
                    $task_status->status = 0;
                
                }else{
                
                    $task_status->status = 1;
                
                }   
            
            }
            
            $task_status->save();
            return Redirect::back()->with('success', 'Status changed successfully.');

        }
    }
   


}
