<?php namespace App\Http\Controllers;
use Illuminate\Support\Faccontactes\Validator;
use Illuminate\Http\Request;
use Session;
use Redirect;
use Auth;
use DB;
class TaskTypesController extends Controller {

    /* Admin to add task_types
    *  23-01-2021
    */
    public function addTaskTypes(Request $req){
      
        return view('admin.task_types.add');
    }
     
    /* Admin to add task_types
    *  23-01-2021
    */
    public function addPostTaskTypes(Request $req){
        
        $task_type                = new \App\TaskType;
        $task_type->name          = $req->input('name');
        $task_type->status        = $req->input('status');
        $task_type->save();
        return Redirect::to('admin/task_types')->with('success', 'TaskType added successfully!');
      

        
    }

    /* Admin to edit task_types
    *  23-01-2021
    */
    public function editTaskTypes(Request $req,$id){


        $task_type  = \App\TaskType::where('id',$id)
                ->first();

      
        return view('admin.task_types.edit',['task_type' => $task_type]);
    }
     
    /* Admin to add task_types
    *  23-01-2021
    */
    public function editPostTaskTypes(Request $req){

        $id = $req->input('id');
    
        $task_type                = \App\TaskType::findOrFail($id);
        $task_type->name          = $req->input('name');
        $task_type->status        = $req->input('status');
        $task_type->save();
        return Redirect::to('admin/task_types')->with('success', 'TaskType updated successfully!');
   

        
    }

    /* Admin list contacts page
    *  17-03-2020
    */
    public function getTaskTypes(){

        $task_types = \App\TaskType::paginate(15);
        return view('admin.task_types.index',['task_types'=>$task_types]);

    }

    /* Admin view contact details
    *  13-03-2019
    */
    public function task_typeView(Request $req,$id){
    
        $task_type  = \App\TaskType::where('id',$id)
             ->first();
        return view('admin.task_types.view',['task_type'=>$task_type]);
    
    }

    /* To delete contact
    *  13-03-2020
    */
    public function TaskTypesDelete($id){
        if(!empty($id)){
            $task_type = \App\TaskType::findOrFail($id);
            if($task_type){
                \App\TaskType::destroy($id);
                return Redirect::to('admin/task_types')->with('success', 'TaskType deleted successfully!');
            }
        }else{
            return Redirect::to('admin/task_types')->with('error', 'You cannot delete!');
        }
    }

    /*Admin change status of task_types
    * 23-01-2021
    */
    public function changeStatus(Request $req){

        $id             = $req->input('id');
        $status         = $req->input('status');
       
        $data           = $req->input('data');
        $task_type  = \App\TaskType::findOrFail($id);
        if($task_type){

            if($data == 1){
                
                $task_type->status = $status;

            }else{
                
                if($status == 1){
                
                    $task_type->status = 0;
                
                }else{
                
                    $task_type->status = 1;
                
                }   
            
            }
            
            $task_type->save();
            return Redirect::back()->with('success', 'Status changed successfully.');

        }
    }
   


}
