@extends('admin.layout.default')
@section('title','Companies')
@section('content')
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Companies</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Desigbations</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            @include ('partials.notifications')
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Companies</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New Company</button>
                       <!-- Signup modal content -->
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">

                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add Company</h4>
                                    </div>

                                    <form class="pl-3 pr-3" action="{{ url('admin/companies/add') }}" method="post">
                                     {!! csrf_field() !!}
                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name" id="name"
                                                required="" placeholder="Name">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Location</label>
                                            <input class="form-control" type="text" name="location" id="name"
                                                required="" placeholder="Location">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Address</label>
                                            <input class="form-control" type="text" name="address" id="name"
                                                required="" placeholder="Address">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control" required="" name="status">
                                                <option value="">Select</option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>


                                      
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="table-responsive">
                        <table
                            class="table table-bordered m-t-30 table-hover contact-list table1" data-paging="true"
                            data-paging-size="7">
                            <thead>
                                <tr>
          
                                    <th>Name</th>
                                    <th>Updated at</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($companies as $company)
                                <tr>
                                    <td>{{ $company->name }}</td>
                                    <td>{{ date('d M Y',strtotime($company->updated_at)) }}</td>
                                     <td>
                                        @if($company->status == 1)
                                        <span class="badge badge-success">Active</span>
                                        @else
                                        <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                    
                                    <a class="edit" title="Edit" style="cursor:pointer;" data-id="{{ $company->id }}"> <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                        <a href="{{URL::to('admin/companies/' . $company->id . '/delete')}}" onclick="return confirm('Do you want to delete this company?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit Company</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@endsection
@section('javascripts')
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("admin/companies/")}}/'+id+'/edit');
        $('#editmodal').modal('show');
    });
})
</script> 
@endsection

