@extends('admin.layout.default')
@section('title','Tasks')
@section('content')
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Tasks</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Tasks</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            @include ('partials.notifications')
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Tasks</h4>
                    <h6 class="card-subtitle"></h6>
       
                    <form class="pl-3 pr-3" action="{{ url('admin/tasks/edit') }}" method="post" enctype="multipart/form-data">
                     {!! csrf_field() !!}
                        <input type="hidden" name="id" value="{{ $task->id }}">
                         <div class="form-group">
                            <label for="username">Name</label>
                            <input class="form-control" type="text" name="name" id="name"
                                required="" placeholder="Name" value="{{ $task->name }}">
                        </div>
                        <div class="form-group">
                            <label for="username">IN/OUT</label>
                            <select class="form-control" required="" name="in_out">
                                <option value="">Select</option>
                                <option value="IN"  <?php if($task->in_out == "IN"){ echo "selected"; } ?>>IN</option>
                                <option value="OUT"  <?php if($task->in_out == "OUT"){ echo "selected"; } ?>>OUT</option>
                                <option value="CC"  <?php if($task->in_out == "CC"){ echo "selected"; } ?>>CC</option>
                                <option value="SELF"  <?php if($task->in_out == "SELF"){ echo "selected"; } ?>>SELF</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Task Type</label>
                            <select class="form-control" required="" name="task_type_id">
                                <option value="">Select</option>
                                @foreach($task_types as $task_type)
                                <option value="{{ $task_type->id }}"  {{ ($task->task_type_id == $task_type->id)? 'selected':''}}>{{ $task_type->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Division</label>
                            <select class="form-control" required="" name="division_id">
                                <option value="">Select</option>
                                @foreach($divisions as $division)
                                <option value="{{ $division->id }}"  {{ ($task->division_id == $division->id)? 'selected':''}}>{{ $division->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                           
                            <input class="form-check-input material-inputs" type="checkbox" id="inlineCheckbox1" value="1" name="to_self"  <?php if($task->to_self == 1){ echo "checked"; } ?>>
                            <label class="form-check-label" for="inlineCheckbox1">To Self</label>
                        </div>
                      
                        <div class="form-group">
                            <label for="username">Priority</label>
                            <!--<input type="text" name="priority" class="form-control" name="priority" value="{{-- $task->priority --}}">-->
                            <select class="form-control" name="priority">
                                <option value="Low" {{ ($task->priority == 'Low')? 'selected':''}}>Low</option>
                                <option value="Medium" {{ ($task->priority == 'Medium')? 'selected':''}}>Medium</option>
                                <option value="High" {{ ($task->priority == 'High')? 'selected':''}}>High</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Descripton</label>
                            <textarea class="form-control" name="description">{{ $task->description }}</textarea>
                        </div>
                        <div class="form-group">
                            <label for="attachment">Attachment</label>
                            <input type="file" name="attachment" class="form-control" value="{{ $task->attachment }}">
                        </div>
                        <div class="form-group">
                            <label for="username">Company</label>
                            <select class="form-control" required="" name="company_id" id="company_id">
                                <option value="">Select</option>
                                @foreach($companies as $company)
                                <option value="{{ $company->id }}"  {{ ($task->company_id == $company->id)? 'selected':''}}>{{ $company->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Assigned Staffs</label>
                            <select class="select2 form-control" multiple="multiple" id="staffs" style="height: 36px;width: 100%;" name="staffs[]">
                                <option value="">Select</option>
                                @foreach($employees as $employee)
                                <option value="{{ $employee->id }}" <?php if($user_ids) { if(in_array($employee->id,$user_ids)){ echo "selected"; } } ?> >{{ $employee->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="cc">CC</label>
                            <select class="select2 form-control" id="cc" style="height: 36px;width: 100%;" name="cc">
                                <option value="">Select</option>
                                @foreach($employees as $employee)
                                <option value="{{ $employee->id }}" <?php if($cc) { if($employee->id==$cc){ echo "selected"; } } ?> >{{ $employee->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="username">Status</label>
                            <select class="form-control" required="" name="status">
                                <option value="">Select</option>
                                <!--<option value="1"  <?php if($task->status == 1){ echo "selected"; } ?>>Active</option>-->
                                <!--<option value="0"  <?php if($task->status == 0){ echo "selected"; } ?>>Inactive</option>-->
                                @foreach($task_statuses as $task_status)
                                <option value="{{ $task_status->id }}" {{ ($task->status == $task_status->id)? 'selected':''}} >{{ $task_status->name }}</option>
                                @endforeach
                            </select>
                        </div>


                      
                        <div class="modal-footer">

                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('javascripts')
<script type="text/javascript">
$(function(){
    $('#company_id').on('change',function(){
        var company_id = $(this).val();
        var urlLike = '{{ url("admin/users/empbycompany") }}/'+company_id;
        var staff = $('#staffs');
        $.ajaxSetup({
          headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        $.ajax({
            type: "GET",
            url: urlLike,
            // data: {company_id: company_id},
            success: function(data){
                // console.log(data);
                // $("#staffs").append(html);
                $("#staffs").empty();
                $("#cc").empty();
                $.each(data, function(id,name) {
                    staff.append($('<option>', {value:id, text:name}));
                    $('#cc').append($('<option>', {value:id, text:name}));
                });
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                console.log(XMLHttpRequest);
            }
        });
        
    });
});
</script>
@endsection
