@extends('admin.layout.default')
@section('title','Tasks')
@section('content')
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Tasks</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Tasks</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            @include ('partials.notifications')
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Tasks</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New Task</button>
                       <!-- Signup modal content -->
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">

                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add Task</h4>
                                    </div>

                                    <form class="pl-3 pr-3" action="{{ url('admin/tasks/add') }}" method="post" enctype="multipart/form-data">
                                     {!! csrf_field() !!}
                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name" id="name"
                                                required="" placeholder="Name">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">IN/OUT</label>
                                            <select class="form-control" required="" name="in_out">
                                                <option value="">Select</option>
                                                <option value="IN">IN</option>
                                                <option value="OUT">OUT</option>
                                                <option value="CC">CC</option>
                                                <option value="SELF">SELF</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Task Type</label>
                                            <select class="form-control" required="" name="task_type_id">
                                                <option value="">Select</option>
                                                @foreach($task_types as $task_type)
                                                <option value="{{ $task_type->id }}">{{ $task_type->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <!--<div class="form-group">-->
                                        <!--    <label for="username">Division</label>-->
                                        <!--    <select class="form-control" required="" name="division_id">-->
                                        <!--        <option value="">Select</option>-->
                                        <!--        @foreach($divisions ?? '' as $division)-->
                                        <!--        <option value="{{-- $division->id --}}">{{-- $division->name --}}</option>-->
                                        <!--        @endforeach-->
                                        <!--    </select>-->
                                        <!--</div>-->
                                        <div class="form-group">
                                           
                                            <input class="form-check-input material-inputs" type="checkbox" id="inlineCheckbox1" value="1" name="to_self">
                                            <label class="form-check-label" for="inlineCheckbox1">To Self</label>
                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="username">Priority</label>
                                            <!--<input type="text" name="priority" class="form-control" name="priority">-->
                                            <select name="priority" class="form-control">
                                                <option value="Low">Low</option>
                                                <option value="Medium">Medium</option>
                                                <option value="High">High</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Descripton</label>
                                            <textarea class="form-control" name="description"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="attachment">Attachment</label>
                                            <input type="file" class="form-control" name="attachment">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Company</label>
                                            <select class="form-control" required="" name="company_id" id="company_id">
                                                <option value="">Select</option>
                                                @foreach($companies as $company)
                                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Assigned staffs</label>

                                            <select class="select2 form-control" multiple="multiple" id="staffs" style="height: 36px;width: 100%;" name="staffs[]">
                                                <option value="">Select</option>
                                                @foreach($employees as $employee)
                                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="cc">CC</label>

                                            <select class="select2 form-control" id="cc" style="height: 36px;width: 100%;" name="cc">
                                                <option value="">Select</option>
                                                @foreach($cc as $cc)
                                                <option value="{{ $cc->id }}">{{ $cc->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control" required="" name="status">
                                                <option value="">Select</option>
                                                @foreach($task_statuses as $task_status)
                                                <option value="{{ $task_status->id }}">{{ $task_status->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>


                                      
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="row">
                        <select id="first" class="form-control col-md-3 col-sm-12">
                            <option value="">Owner</option>
                            @foreach($owners as $owner)
                            <option value="{{ $owner->name }}">{{ $owner->name }}</option>
                            @endforeach
                        </select>
                        <!--&emsp;-->
                        <!--<select id="second" class="form-control col-md-3 col-sm-12">-->
                        <!--    <option value="">Division</option>-->
                        <!--    @foreach($divisions ?? '' as $division)-->
                        <!--    <option value="{{-- $division->name --}}">{{-- $division->name --}}</option>-->
                        <!--    @endforeach-->
                        <!--</select>-->
                         &emsp;
                         <select id="third" class="form-control col-md-3 col-sm-12">
                            <option value="">Task Type</option>
                            @foreach($task_types as $task_type)
                            <option value="{{ $task_type->name }}">{{ $task_type->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="row" style="margin-bottom:10px;">
                        <select id="fourth" class="form-control col-md-3 col-sm-12">
                            <option value="">Company</option>
                            @foreach($companies as $company)
                            <option value="{{ $company->name }}">{{ $company->name }}</option>
                            @endforeach
                        </select>
                        &emsp;
                        <select id="fifth" class="form-control col-md-3 col-sm-12">
                            <option value="">Status</option>
                            <!--<option value="Active">Active</option>-->
                            <!--<option value="Inactive">Inactive</option>-->
                            @foreach($task_statuses as $task_status)
                            <option value="{{ $task_status->name }}">{{ $task_status->name }}</option>
                            @endforeach
                        </select>
                        &emsp;
                        <select id="sixth" class="form-control col-md-3 col-sm-12" style="margin-bottom:10px;">
                            <option value="">IN/OUT</option>
                            <option value="IN">IN</option>
                            <option value="OUT">OUT</option>
                            <option value="CC">CC</option>
                            <option value="SELF">SELF</option>
                        </select>
                        <input type="date" name="from_date" id="seventh" class="form-control col-md-3 col-sm-12">
                        &emsp;
                        <input type="date" name="to_date" id="eighth" class="form-control col-md-3 col-sm-12">
                    </div>
                    <div class="row">
                    </div>
                    <div class="table-responsive">
                        <table id="default_order" class="table table-striped table-bordered display"
                                        style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>IN/OUT</th>
                                    <th>Owner</th>
                                    <!--<th>Division</th>-->
                                    <th>Task Type</th>
                                    <th>Company</th>
                                    <th>Name</th>
                                    <th>Priority</th>
                                    <th>Updated at</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($tasks as $task)
                                <tr>
                                    <td>{{ $task->task_id }}</td>
                                    <td>{{ trim($task->in_out) }}</td>
                                    <td>{{ $task->owner['name'] }}</td>
                                    <!--<td>{{-- $task->division['name'] --}}</td>-->
                                    <td>{{ $task->task_types['name'] }}</td>
                                    <td>{{ $task->company['name'] }}</td>
                                    <td>{{ $task->name }}</td>
                                    <td>{{ $task->priority }}</td>
                                    <td>{{ date('d M Y, H:i',strtotime($task->updated_at)) }}</td>
                                    <td>
                                        <!--@if($task->status == 1)-->
                                        <!--<span class="badge badge-success">Active</span>-->
                                        <!--@else-->
                                        <!--<span class="badge badge-danger">Pending</span>-->
                                        <!--@endif-->
                                        <span class="badge" style="background-color:{{$task->task_status['color']}}; color:#ffffff; width:87px;">
                                            {{ $task->task_status['name'] }}
                                        </span>
                                    </td>
                                    <td>
                                    
                                    <a class="view" title="View" style="cursor:pointer;" data-id="{{ $task->id }}"> <i class=" fas fa-eye"></i> </a>
                                    <a class="chat" title="Chat" style="cursor:pointer;" data-id="{{ $task->id }}"> <i class=" fas fa-comments"></i> </a>
                                    <a class="history" title="Transfer" style="cursor:pointer;" data-id="{{ $task->id }}"> <i class=" fas fa-exchange-alt"></i> </a>
                                    <a class="edit" title="Edit" style="cursor:pointer;" href="{{URL::to('admin/tasks/' . $task->id . '/edit')}}" > <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                    <a class="reminder" title="Add reminder" style="cursor:pointer;" data-id="{{ $task->id }}"> <i class=" fas fa-clock"></i> </a>
                                    <a href="{{URL::to('admin/tasks/' . $task->id . '/delete')}}" onclick="return confirm('Do you want to delete this task?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    {{ $tasks->render() }}
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit Task</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- View modal content -->
<div id="viewmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Task Details</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- Signup modal content -->
<div id="remindermodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Add Reminder</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- History modal content -->
<div id="historymodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Task Transfer</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- Chat modal content -->
<div id="chatmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Chat</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@endsection
@section('javascripts')
<script src="https://js.pusher.com/7.0/pusher.min.js"></script>
<script type="text/javascript">
$(function(){
    
    $('#company_id').on('change',function(){
        var company_id = $(this).val();
        var urlLike = '{{ url("admin/users/empbycompany") }}/'+company_id;
        var staff = $('#staffs');
        $.ajaxSetup({
          headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        $.ajax({
            type: "GET",
            url: urlLike,
            success: function(data){
                $("#staffs").empty();
                $("#cc").empty();
                $.each(data, function(id,name) {
                    staff.append($('<option>', {value:id, text:name}));
                    $('#cc').append($('<option>', {value:id, text:name}));
                });
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                console.log(XMLHttpRequest);
            }
        });
        
    });
    
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("admin/tasks/")}}/'+id+'/edit');
        $('#editmodal').modal('show');
    });
    
    $('.view').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("admin/tasks/")}}/'+id+'/view');
        $('#viewmodal').modal('show');
        $("#viewmodal").on('shown.bs.modal', function () {
            output = $('#percentage').html();
            $(document).on('input', '#progress', function() {
                $('.percentage').html(this.value);
            });
        });
    });

    $('.reminder').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("admin/tasks/")}}/'+id+'/reminder');
        $('#remindermodal').modal('show');
    });
    
    $('.history').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("admin/tasks/")}}/'+id+'/history');
        $('#historymodal').modal('show');
        $("#historymodal").on('shown.bs.modal', function () {
            $('.transfer_company').on('change',function(){
                var company_id = $(this).val();
                var urlLike = '{{ url("admin/users/empbycompany") }}/'+company_id;
                var staff = $('.transfer_to');
                $.ajaxSetup({
                  headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
                });
                $.ajax({
                    type: "GET",
                    url: urlLike,
                    success: function(data){
                        $(".transfer_to").empty();
                        $.each(data, function(id,name) {
                            staff.append($('<option>', {value:id, text:name}));
                        });
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        console.log(XMLHttpRequest);
                    }
                });
                
            });
        });
    });
    
    $('.chat').on('click',function(){
        id = $(this).data('id');
        $('.load_view').load('{{URL::to("admin/tasks/")}}/'+id+'/chat');
        $('#chatmodal').modal('show');
    });
});

var table = table =  $('#default_order').DataTable( {});

$('#first').on('change', function () {
        table.columns(2).search( this.value).draw();
} );

$('#second').on('change', function () {
        table.columns(3).search( this.value).draw();
} );

$('#third').on('change', function () {
        table.columns(3).search( this.value).draw();
} );
$('#fourth').on('change', function () {
        table.columns(4).search( this.value).draw();
} );
$('#fifth').on('change', function () {
        table.columns(8).search( this.value).draw();
} );
$('#sixth').on('change', function () {
        table.columns(1).search( this.value).draw();
} );
$('#seventh').on('change', function () {
        table.columns(7).search(this.value).draw("<=");
} );
$('#eighth').on('change', function () {
        table.columns(7).search( this.value).draw();
} );

// Date Filter

$(function() {

  $("#seventh").datepicker({
    showOn: "button",
    "onSelect": function(date) {
      minDateFilter = new Date(date).getTime();
      table.fnDraw();
    }
  }).keyup(function() {
    minDateFilter = new Date(this.value).getTime();
    table.fnDraw();
  });

  $("#eighth").datepicker({
    showOn: "button",
    "onSelect": function(date) {
      maxDateFilter = new Date(date).getTime();
      table.fnDraw();
    }
  }).keyup(function() {
    maxDateFilter = new Date(this.value).getTime();
    table.fnDraw();
  });

});

// Date range filter
minDateFilter = "";
maxDateFilter = "";

$.fn.dataTableExt.afnFiltering.push(
  function(oSettings, aData, iDataIndex) {
    if (typeof aData._date == 'undefined') {
      aData._date = new Date(aData[0]).getTime();
    }

    if (minDateFilter && !isNaN(minDateFilter)) {
      if (aData._date < minDateFilter) {
        return false;
      }
    }

    if (maxDateFilter && !isNaN(maxDateFilter)) {
      if (aData._date > maxDateFilter) {
        return false;
      }
    }

    return true;
  }
);

$('.user').on('click',function(){
    receiver_id = "testimonial";
    $('#messages').html(receiver_id);
});

</script> 
@endsection

