@extends('admin.layout.default')
@section('title','Users')
@section('content')
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Users</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Users</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            @include ('partials.notifications')
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Users</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New User</button>
                       <!-- Signup modal content -->
                     
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add User</h4>
                                    </div>
                                    @include ('partials.notifications')
                                    <form class="pl-3 pr-3" action="{{ url('admin/users/add') }}" method="post">
                                     {!! csrf_field() !!}
                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name"
                                                required="" placeholder="Name" pattern="[a-zA-Z\s]*" value="{{ old('name') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Username</label>
                                            <input class="form-control" type="text" name="username"
                                                required="" placeholder="Username" pattern="[a-zA-Z]*" value="{{ old('username') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Email</label>
                                            <input class="form-control" type="email" name="email" 
                                                required="" placeholder="Email"  value="{{ old('email') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">User Type</label>
                                            <select class="form-control" required="" name="user_type_id">
                                                <option value="">Select</option>
                                                @foreach($user_types as $user_type)
                                                <option value="{{ $user_type->id }}"  {{(old('user_type_id') == $user_type->id)? 'selected':''}}>{{ $user_type->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Password</label>
                                            <input class="form-control" type="password" name="password" 
                                                required="" placeholder="Password" minlength="5" title="please enter password with min 5 letters">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Conform Password</label>
                                            <input class="form-control" type="password" name="confirm_password" 
                                                required="" placeholder="confirm Password" minlength="5" title="please enter password with min 5 letters">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Telephone</label>
                                            <input class="form-control" type="text" name="telephone" minlength="8" maxlength="15" 
                                                placeholder="Telephone"  value="{{ old('telephone') }}" onkeypress='return isNumberKey(event);'>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Mobile Phone</label>
                                            <input class="form-control" type="text" name="mobile" minlength="8" maxlength="15" 
                                                placeholder="Mobile Phone"  value="{{ old('mobile') }}" onkeypress='return isNumberKey(event);'>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Extension</label>
                                            <input class="form-control" type="text" name="extension" 
                                                placeholder="Extension"  value="{{ old('extension') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Address</label>
                                            <input class="form-control" type="text" name="address" 
                                                placeholder="Extension"  value="{{ old('address') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Date of Join</label>
                                            <input class="form-control" type="date" name="date_of_join" 
                                                placeholder="Date of Join"  value="{{ old('date_of_join') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Designation</label>
                                            <select class="form-control" name="designation_id" required="">
                                                <option value="">Select</option>
                                                @foreach($designations as $designation)
                                                <option value="{{ $designation->id }}"  {{(old('designation_id') == $designation->id)? 'selected':''}}>{{ $designation->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                         <div class="form-group">
                                            <label for="username">Company</label>
                                            <select class="form-control" name="company_id" required="">
                                                <option value="">Select</option>
                                                @foreach($companies as $company)
                                                <option value="{{ $company->id }}"  {{(old('company_id') == $company->id)? 'selected':''}}>{{ $company->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Division</label>
                                            <select class="form-control" name="division_id">
                                                <option value="">Select</option>
                                                @foreach($divisions as $division)
                                                <option value="{{ $division->id }}"  {{(old('division_id') == $division->id)? 'selected':''}}>{{ $division->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control"  name="status" required="">
                                                <option value="">Select</option>
                                                <option value="1" {{(old('status')== 1)? 'selected':''}}>Active</option>
                                                <option value="0" {{(old('status')== 0)? 'selected':''}}>Inactive</option>
                                            </select>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="row">
                     
                        <select id="second" class="form-control" style="width:40% !important;">
                            <option value="">Select User Type</option>
                            @foreach($user_types as $user_type)
                            <option value="{{ $user_type->name }}">{{ $user_type->name }}</option>
                            @endforeach
                        </select>
                        &emsp;
                        <select id="first" class="form-control" style="width:40% !important;">
                            <option value="">Select Company</option>
                            @foreach($companies as $company)
                            <option value="{{ $company->name }}">{{ $company->name }}</option>
                            @endforeach
                        </select>
                      
                    </div>
                        
                    <div class="table-responsive">
                        <table id="default_order"
                            class="table table-bordered m-t-30 table-hover contact-list" data-paging="true"
                            data-paging-size="7">
                            <thead>
                                <tr>
          
                                    <th>Name</th>
                                    <th>User Type</th>
                                    <th id="example">Company</th>
                                    <th>Last Active</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)
                                <tr>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->user_types['name'] }}</td>
                                    <td>{{ $user->companies['name'] }}</td>
                                    <td>

                                            @if(Cache::has('user-is-online-' . $user->id))
                                               <b style="color:#4cc125;">Online</b>
                                            @else
                                                {{ date('d M Y',strtotime($user->updated_at)) }}
                                            @endif
                                    </td>
                                    <td>
                                        @if($user->status == 1)
                                        <span class="badge badge-success">Active</span>
                                        @else
                                        <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                    
                                    <a class="edit" title="Edit" style="cursor:pointer;" data-id="{{ $user->id }}"> <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                        <a href="{{URL::to('admin/users/' . $user->id . '/delete')}}" onclick="return confirm('Do you want to delete this user?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    {{ $users->render() }}
                </div>

            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit User</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@endsection
@section('styles')
<style src="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css"></style>
@endsection
@section('javascript_links')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script type="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
@endsection
@section('javascripts')
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("admin/users/")}}/'+id+'/edit');
        $('#editmodal').modal('show');
    });
})
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : event.keyCode;
    console.log(charCode);
    if (charCode != 43 &&  charCode > 31
        && (charCode < 48 || charCode > 57))
        return false;

    return true;
}
var table = table =  $('#default_order').DataTable( {});
$('#first').on('change', function () {
        table.columns(2).search( this.value).draw();
} );

$('#second').on('change', function () {
        table.columns(1).search( this.value).draw();
} );



</script> 
<!-- <script type="text/javascript">
@if (count($errors) > 0)
    $('#myModal').modal('show');
@endif
</script> -->

@endsection

