@extends('employee.layout.default')
@section('title','Tasks')
@section('content')
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Tasks</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
         <!--    <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li> -->
            <li class="breadcrumb-item active">Tasks</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            @include ('partials.notifications')
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Tasks</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New Task</button>
                       <!-- Signup modal content -->
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">

                                <div class="modal-body">
                                   <!--  <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add Task</h4>
                                    </div> -->

                                    <form class="pl-3 pr-3" action="{{ url('employee/tasks/add') }}" method="post" enctype="multipart/form-data">
                                     {!! csrf_field() !!}
                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name" id="name"
                                                required="" placeholder="Name">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">IN/OUT</label>
                                            <select class="form-control" required="" name="in_out">
                                                <option value="">Select</option>
                                                <option value="IN">IN</option>
                                                <option value="OUT">OUT</option>
                                                <option value="CC">CC</option>
                                                <option value="SELF">SELF</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Task Type</label>
                                            <select class="form-control" required="" name="task_type_id">
                                                <option value="">Select</option>
                                                @foreach($task_types as $task_type)
                                                <option value="{{ $task_type->id }}">{{ $task_type->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <!--<div class="form-group">-->
                                           
                                        <!--    <input class="form-check-input material-inputs" type="checkbox" id="inlineCheckbox1" value="1" name="to_self">-->
                                        <!--    <label class="form-check-label" for="inlineCheckbox1">To Self</label>-->
                                        <!--</div>-->
                                      
                                        <div class="form-group">
                                            <label for="username">Priority</label>
                                            <!--<input type="text" name="priority" class="form-control" name="priority">-->
                                            <select name="priority" class="form-control">
                                                <option value="Low">Low</option>
                                                <option value="Medium">Medium</option>
                                                <option value="High">High</option>
                                            </select>
                                        </div>
                                         <div class="form-group">
                                            <label for="username">Descripton</label>
                                            <textarea class="form-control" name="description"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="attachment">Attachment</label>
                                            <input type="file" class="form-control" name="attachment">
                                        </div>

                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control" required="" name="status">
                                                <option value="">Select</option>
                                                @foreach($task_statuses as $task_status)
                                                    <option value="{{ $task_status->id }}">{{ $task_status->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>


                                      
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="row">
                        <select id="first" class="form-control col-md-3 col-sm-12">
                            <option value="">Owner</option>
                            @foreach($owners as $owner)
                            <option value="{{ $owner->name }}">{{ $owner->name }}</option>
                            @endforeach
                        </select>
                        &emsp;
                        <select id="second" class="form-control col-md-3 col-sm-12">
                            <option value="">Task Type</option>
                            @foreach($task_types as $task_type)
                            <option value="{{ $task_type->name }}">{{ $task_type->name }}</option>
                            @endforeach
                        </select>
                        &emsp;
                        <select id="third" class="form-control col-md-3 col-sm-12">
                            <option value="">Status</option>
                            <!--<option value="Active">Active</option>-->
                            <!--<option value="Inactive">Inactive</option>-->
                            @foreach($task_statuses as $task_status)
                            <option value="{{ $task_status->name }}">{{ $task_status->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="row">
                        <input type="date" name="from_date" id="seventh" class="form-control col-md-3 col-sm-12">
                        &emsp;
                        <input type="date" name="to_date" id="eighth" class="form-control col-md-3 col-sm-12">
                    </div>
                    <div class="table-responsive">
                        <table id="default_order" class="table table-striped table-bordered display"
                                        style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>IN/OUT</th>
                                    <th>Owner</th>
                                    <th>Task Type</th>
                                    <th>Company</th>
                                    <th>Name</th>
                                    <th>Priority</th>
                                    <th>Updated at</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($tasks as $task)
                                <tr>
                                    <td>{{ $task->task_id }}</td>
                                    <td>{{ trim($task->in_out) }}</td>
                                    <td>{{ $task->owner['name'] }}</td>
                                    <td>{{ $task->task_types['name'] }}</td>
                                    <td>{{ $task->company['name'] }}</td>
                                    <td>{{ $task->name }}</td>
                                    <td>{{ $task->priority }}</td>
                                    <td>{{ date('d M Y, H:i',strtotime($task->updated_at)) }}</td>
                                    <td>
                                        <span class="badge" style="background-color:{{$task->task_status['color']}}; color:#ffffff; width:87px;">
                                            {{ $task->task_status['name'] }}
                                        </span>
                                    </td>
                                    <td>
                                    
                                        <!--<a class="edit" title="Edit" style="cursor:pointer;" data-id="{{ $task->id }}"> <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>-->
                                        <!--<a href="{{URL::to('employee/tasks/' . $task->id . '/delete')}}" onclick="return confirm('Do you want to delete this task?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a> -->
                                        <a class="view" title="View" style="cursor:pointer;" data-id="{{ $task->id }}"> <i class=" fas fa-eye"></i> </a>
                                        <a class="chat" title="Chat" style="cursor:pointer;" data-id="{{ $task->id }}" id="{{ $task->id }}"> <i class=" fas fa-comments"></i> </a>
                                        <a class="history" title="Transfer" style="cursor:pointer;" data-id="{{ $task->id }}"> <i class=" fa fa-exchange-alt"></i> </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    {{ $tasks->render() }}
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit Task</h4>
            </div>
            <div class="modal-body load_edit" id="load_edit">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- View modal content -->
<div id="viewmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Task Details</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- History modal content -->
<div id="historymodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Task Transfer</h4>
            </div>
            <div class="modal-body load_history" id="load_history">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- Chat modal content -->
<div id="chatmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Chat</h4>
            </div>
            <div class="modal-body load_chat" id="load_chat">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@endsection
@section('javascripts')
<script src="https://js.pusher.com/7.0/pusher.min.js"></script>
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_edit').load('{{URL::to("employee/tasks/")}}/'+id+'/edit');
        $('#editmodal').modal('show');
    });
    
    $('.view').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("employee/tasks/")}}/'+id+'/view');
        $('#viewmodal').modal('show');
        $("#viewmodal").on('shown.bs.modal', function () {
            output = $('#percentage').html();
            $(document).on('input', '#progress', function() {
                $('.percentage').html(this.value);
            });
        });
    });
    
    $('.history').on('click',function(){
        id = $(this).data('id');       
        $('.load_history').load('{{URL::to("employee/tasks/")}}/'+id+'/history');
        $('#historymodal').modal('show');
    });
    $('.chat').on('click',function(){
        id = $(this).data('id');
        $('.load_chat').load('{{URL::to("employee/tasks/")}}/'+id+'/chat');
        $('#chatmodal').modal('show');
        $("#chatmodal").on('shown.bs.modal', function () {
            // Enable pusher logging - don't include this in production
            Pusher.logToConsole = true;
        
            var pusher = new Pusher('12c9aec6f612e5ab552b', {
              cluster: 'ap2'
            });
        
            var channel = pusher.subscribe('my-channel');
            channel.bind('my-event', function (data) {
                // alert(JSON.stringify(data));
                if (my_id == data.from) {
                    // $('#' + data.task_id).click();
                    // $('#' + data.task_id).click();
                    $('#7').click();
                } else if (my_id == data.task_id) {
                    if (receiver_id == data.from) {
                        // if receiver is selected, reload the selected user ...
                        $('#' + data.from).click();
                    } else {
                        // if receiver is not seleted, add notification for that user
                        var pending = parseInt($('#' + data.from).find('.pending').html());
                        if (pending) {
                            $('#' + data.from).find('.pending').html(pending + 1);
                        } else {
                            $('#' + data.from).append('<span class="pending">1</span>');
                        }
                    }
                }
            });
            $(document).on('keyup', '.input-text input', function(e){
                var message = $(this).val();
                if(e.keyCode == 13 && message != '' && id != '') {
                    $(this).val('');
                    var datastr = 'task_id=' + id + '&message=' + message;
                    $.ajaxSetup({
                      headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      }
                    });
                    $.ajax({
                        type: "post",
                        url: '{{url("employee/tasks/chat")}}',
                        data: datastr,
                        cache: false,
                        success: function(data) {
                        },
                        error: function(jqXHR, status, err, data) {
                        },
                        complete: function() {
                            scrollToBottomFunc();
                        }
                    });
                }
            });
        });
    });
    
    var table = table =  $('#default_order').DataTable();
    
    $('#first').on('change', function () {
        table.columns(2).search( this.value).draw();
    });
    $('#second').on('change', function () {
        table.columns(3).search( this.value).draw();
    });
    $('#third').on('change', function () {
        table.columns(8).search( this.value).draw();
    });
    
    
    
    $("#chatmodal").on('shown.bs.modal', function () {
        
    });
    
});
function scrollToBottomFunc() {
    $('.message-wrapper').animate({
        scrollTop: $('.message-wrapper').get(0).scrollHeight
    }, 50);
}
</script> 
@endsection

