<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', 'UsersController@getLogin');
Route::post('user/login','UsersController@doLogin');
Route::get('logout','UsersController@getLogout');


Route::get('forgotpassword', array('as' => 'forgotpassword', 'uses' => 'UsersController@forgotPassword'));

Route::post('forgotpassword', array('as' => 'forgotpassword', 'uses' => 'UsersController@forgotPassword'));
	

Route::group([ 'prefix' => 'admin', 'middleware' => 'App\Http\Middleware\AdminMiddleware'], function() {
	
	Route::get('/', array('as' => 'dashboard','uses' => 'UsersController@getAdminDashboard'));

	Route::get('profile', array('as' => 'profile','uses' => 'UsersController@adminprofile'));

	Route::post('editprofile', array('as' => 'editprofile','uses' => 'UsersController@admineditprofile'));

	Route::get('changepassword', array('as' => 'changepassword','uses' => 'UsersController@changepassword'));

	Route::post('changepassword', array('as' => 'postchangepassword','uses' => 'UsersController@postchangepassword'));

	Route::any('users','UsersController@getUsers');
	Route::any('users/{id}/delete','UsersController@userDelete');
	Route::post('users/change_status','UsersController@changeStatus');
	Route::get('users/add','UsersController@addUsers');
	Route::post('users/add','UsersController@addPostUsers');
	Route::get('users/{id}/edit','UsersController@editUsers');
	Route::post('users/edit','UsersController@editPostUsers');
	Route::get('users/empbycompany/{id}','UsersController@getUsersByCompany');

	Route::any('designations','DesignationsController@getDesignations');
	Route::any('designations/{id}/delete','DesignationsController@DesignationsDelete');
	Route::post('designations/change_status','DesignationsController@changeStatus');
	Route::get('designations/add','DesignationsController@addDesignations');
	Route::post('designations/add','DesignationsController@addPostDesignations');
	Route::get('designations/{id}/edit','DesignationsController@editDesignations');
	Route::post('designations/edit','DesignationsController@editPostDesignations');

	Route::any('companies','CompaniesController@getCompanies');
	Route::any('companies/{id}/delete','CompaniesController@CompaniesDelete');
	Route::post('companies/change_status','CompaniesController@changeStatus');
	Route::get('companies/add','CompaniesController@addCompanies');
	Route::post('companies/add','CompaniesController@addPostCompanies');
	Route::get('companies/{id}/edit','CompaniesController@editCompanies');
	Route::post('companies/edit','CompaniesController@editPostCompanies');

	Route::any('divisions','DivisionsController@getDivisions');
	Route::any('divisions/{id}/delete','DivisionsController@DivisionsDelete');
	Route::post('divisions/change_status','DivisionsController@changeStatus');
	Route::get('divisions/add','DivisionsController@addDivisions');
	Route::post('divisions/add','DivisionsController@addPostDivisions');
	Route::get('divisions/{id}/edit','DivisionsController@editDivisions');
	Route::post('divisions/edit','DivisionsController@editPostDivisions');

	Route::any('task_types','TaskTypesController@getTaskTypes');
	Route::any('task_types/{id}/delete','TaskTypesController@TaskTypesDelete');
	Route::post('task_types/change_status','TaskTypesController@changeStatus');
	Route::get('task_types/add','TaskTypesController@addTaskTypes');
	Route::post('task_types/add','TaskTypesController@addPostTaskTypes');
	Route::get('task_types/{id}/edit','TaskTypesController@editTaskTypes');
	Route::post('task_types/edit','TaskTypesController@editPostTaskTypes');

	Route::any('task_statuses','TaskStatusesController@getTaskStatuses');
	Route::any('task_statuses/{id}/delete','TaskStatusesController@TaskStatusesDelete');
	Route::post('task_statuses/change_status','TaskStatusesController@changeStatus');
	Route::get('task_statuses/add','TaskStatusesController@addTaskStatuses');
	Route::post('task_statuses/add','TaskStatusesController@addPostTaskStatuses');
	Route::get('task_statuses/{id}/edit','TaskStatusesController@editTaskStatuses');
	Route::post('task_statuses/edit','TaskStatusesController@editPostTaskStatuses');

	Route::any('tasks','TasksController@getTasks');
	Route::any('tasks/{id}/delete','TasksController@TasksDelete');
	Route::post('tasks/change_status','TasksController@changeStatus');
	Route::get('tasks/add','TasksController@addTasks');
	Route::post('tasks/add','TasksController@addPostTasks');
	Route::get('tasks/{id}/edit','TasksController@editTasks');
	Route::post('tasks/edit','TasksController@editPostTasks');
	Route::get('tasks/{id}/reminder','TasksController@reminder');
	Route::post('tasks/reminder','TasksController@postreminder');
	Route::any('tasks/{id}/delete-reminder','TasksController@reminderdelete');
	
	Route::get('tasks/{id}/view','TasksController@viewAdminTasks');
	Route::post('tasks/progress','TasksController@editProgress');
	Route::get('attachment/download/{id}','TasksController@download');
	Route::get('tasks/{id}/history','TasksController@history');
	Route::post('taskhistory/add','TasksController@taskTransfer');
	Route::get('tasks/{id}/chat','TasksController@chat');
	
	Route::any('messages','MessagesController@getMessages');
	Route::get('message/{id}','MessagesController@getMessage')->name('message');
	Route::post('message','MessagesController@sendMessage');


});


Route::get('resetpassword/{user_id}/{key}', array('as' => 'resetpassword', 'uses' => 'UsersController@resetPassword'));

Route::post('resetpassword', array('as' => 'postresetpassword', 'uses' => 'UsersController@postResetPassword'));

Route::group([ 'prefix' => 'manager', 'middleware' => 'App\Http\Middleware\ManagerMiddleware'], function() {
	
	Route::get('/', array('as' => 'dashboard','uses' => 'UsersController@getManagerDashboard'));
	
	Route::get('profile', array('as' => 'profile','uses' => 'UsersController@managerprofile'));

	Route::post('editprofile', array('as' => 'editprofile','uses' => 'UsersController@managereditprofile'));
	
	Route::get('changepassword', array('as' => 'changepassword','uses' => 'UsersController@changepassword'));

	Route::post('changepassword', array('as' => 'postchangepassword','uses' => 'UsersController@postchangepassword'));

	Route::any('tasks','TasksController@getManagerTasks');
	Route::any('tasks/{id}/delete','TasksController@ManagerTasksDelete');
	Route::any('tasks/{id}/delete','TasksController@ManagerTasksDelete');
	Route::get('tasks/add','TasksController@addManagerTasks');
	Route::post('tasks/add','TasksController@addPostManagerTasks');
	Route::get('tasks/{id}/edit','TasksController@editManagerTasks');
	Route::post('tasks/edit','TasksController@editPostManagerTasks');

	Route::any('users','UsersController@getManagerUsers');
	Route::any('users/{id}/delete','UsersController@userManagerDelete');
	Route::get('users/add','UsersController@addManagerUsers');
	Route::post('users/add','UsersController@addPostManagerUsers');

	Route::get('users/{id}/edit','UsersController@editManagerUsers');
	Route::post('users/edit','UsersController@editPostManagerUsers');
	
	Route::get('tasks/{id}/view','TasksController@viewManagerTasks');
	Route::post('tasks/progress','TasksController@editManagerProgress');
	Route::get('attachment/download/{id}','TasksController@download');
	Route::get('tasks/{id}/history','TasksController@history');
	Route::post('taskhistory/add','TasksController@taskTransfer');
	Route::get('tasks/{id}/chat','TasksController@chat');
	
	Route::any('messages','MessagesController@getManagerMessages');
	Route::get('message/{id}','MessagesController@getManagerMessage')->name('message');
	Route::post('message','MessagesController@sendManagerMessage');

});

Route::group([ 'prefix' => 'employee', 'middleware' => 'App\Http\Middleware\EmployeeMiddleware'], function() {
	
	Route::get('/', array('as' => 'dashboard','uses' => 'UsersController@getEmployeeDashboard'));
	
	Route::get('profile', array('as' => 'profile','uses' => 'UsersController@employeeprofile'));

	Route::post('editprofile', array('as' => 'editprofile','uses' => 'UsersController@employeeeditprofile'));
	
	Route::get('changepassword', array('as' => 'changepassword','uses' => 'UsersController@changepassword'));

	Route::post('changepassword', array('as' => 'postchangepassword','uses' => 'UsersController@postchangepassword'));

	Route::any('tasks','TasksController@getEmployeeTasks');
	Route::any('tasks/{id}/delete','TasksController@EmployeeTasksDelete');
	Route::get('tasks/add','TasksController@addEmployeeTasks');
	Route::post('tasks/add','TasksController@addPostEmployeeTasks');
	Route::get('tasks/{id}/edit','TasksController@editEmployeeTasks');
	Route::post('tasks/edit','TasksController@editPostEmployeeTasks');
	
	Route::get('tasks/{id}/view','TasksController@viewEmployeeTasks');
	Route::post('tasks/progress','TasksController@editEmployeeProgress');
	Route::get('attachment/download/{id}','TasksController@download');
	Route::get('tasks/{id}/history','TasksController@history');
	Route::post('taskhistory/add','TasksController@taskTransfer');
	Route::get('tasks/{id}/chat','TasksController@chat');
	Route::post('tasks/chat','TasksController@sendTaskChat');
	
	Route::any('messages','MessagesController@getEmployeeMessages');
	Route::get('message/{id}','MessagesController@getEmployeeMessage')->name('message');
	Route::post('message','MessagesController@sendEmployeeMessage');

});

Route::get('/clear-cache', function() {
    $run = Artisan::call('config:clear');
    $run = Artisan::call('cache:clear');
    $run = Artisan::call('config:cache');
    return 'FINISHED';  
});



